﻿/*******************************************************}
{                                                       }
{       RichView                                        }
{       Custom hints demo                               }
{       For C++Builder 2009+                            }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************/

// Property settings:
// RichViewEdit1->ShowHints = True
// rvoShowItemHints in RichViewEdit1->Options
// RichViewEdit1->CustomHint = BalloonHint1

#include <vcl.h>
#include <GifImg.hpp>
#include <PngImage.hpp>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "RichView"
#pragma link "RVEdit"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
  RichViewEdit1->Clear();
  RichViewEdit1->AddNL("Custom Hints", 1, 1);
  RichViewEdit1->AddNL("Hyperlinks: ", 0, 0);
  RichViewEdit1->AddNLTag("trichview.com", 2, -1, Integer(StrNew(L"http://www.trichview.com")));
  RichViewEdit1->SetItemExtraStrProperty(RichViewEdit1->ItemCount-1, rvespHint, "TRichView homepage");

  RichViewEdit1->AddNL("Hypertext pictures: ", 0, 0);
  TGraphic* gr = new Graphics::TBitmap;
  gr->Assign(Image2->Picture->Graphic);
  RichViewEdit1->AddHotPictureTag("",  gr, -1, rvvaAbsMiddle,
    Integer(StrNew(L"http://en.wikipedia.org/wiki/Greek_alphabet")));
  RichViewEdit1->SetItemExtraStrProperty(RichViewEdit1->ItemCount-1, rvespHint, L"Αβγ");

  RichViewEdit1->AddNL("Pictures: ", 0, 0);
  gr = new TIcon;
  gr->Assign(Image1->Picture->Graphic);
  RichViewEdit1->AddPictureEx("",  gr, -1, rvvaAbsMiddle);
  RichViewEdit1->SetItemExtraStrProperty(RichViewEdit1->ItemCount-1, rvespHint, L"Солнце"); // "The Sun" in Russian

  RichViewEdit1->Format();
}
//---------------------------------------------------------------------------
UnicodeString GetGraphicFormatName(TGraphic* gr)
{
  if (gr->InheritsFrom(__classid(Graphics::TBitmap)))
    return "Windows bitmap";
  if (gr->InheritsFrom(__classid(TIcon)))
    return "Icon";
  if (gr->InheritsFrom(__classid(TMetafile)))
    return "Windows metafile";
  if (gr->InheritsFrom(__classid(TJPEGImage)))
    return "JPEG image";
  if (gr->InheritsFrom(__classid(TGIFImage)))
    return "GIF image";
  if (gr->InheritsFrom(__classid(TPngImage)))
    return "PNG image";
  return "Unknown image format";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichViewEdit1ItemHint(TCustomRichView *Sender, TCustomRVData *RVData,
          int ItemNo, UnicodeString &HintText)
{
  UnicodeString DefaultHint = HintText;
  for (int i = 1; i<=DefaultHint.Length(); i++)
    if (DefaultHint[i]=='|')
      DefaultHint[i] = ' ';
  if (DefaultHint!="")
    DefaultHint = ": "+DefaultHint;
  if (RVData->GetItemStyle(ItemNo)==rvsPicture ||
      RVData->GetItemStyle(ItemNo)==rvsHotPicture)
  {
    // image
    TRVAnsiString ItemName;
    TRVVAlign Align;
    TGraphic* Graphic;
    int Tag;
    RVData->GetPictureInfo(ItemNo, ItemName, Graphic, Align, Tag);
    UnicodeString Target;
    if (RVData->GetItemStyle(ItemNo)==rvsHotPicture)
      Target = UnicodeString("; Target: ")+(wchar_t*)Tag;
    else
      Target = "";
    UnicodeString PicDetails = GetGraphicFormatName(Graphic)+" "+
      IntToStr(Graphic->Width)+L"×"+IntToStr(Graphic->Height);
    HintText = UnicodeString("Image")+DefaultHint+"|"+PicDetails+Target+"|1";
  }
  else if (RVData->GetItem(ItemNo)->GetBoolValueEx(rvbpJump, RVStyle1))
  {
    // hyperlink
    UnicodeString Target = UnicodeString("Target: ")+(wchar_t*)(RVData->GetItemTag(ItemNo));
    HintText = UnicodeString("Hyperlink")+DefaultHint+"|"+Target+"|0";
  }
}
//---------------------------------------------------------------------------

